/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.thelimeglass.Expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.thelimeglass.Utils.Annotations.Config;
import com.gmail.thelimeglass.Utils.Annotations.PropertyType;
import com.gmail.thelimeglass.Utils.Annotations.Syntax;
import com.gmail.thelimeglass.Utils.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Syntax(value={"[the] block (break delay|durability|hardness) of [all] %block%", "[all] %block%'s block (break delay|durability|hardness)"})
@Config(value="BlockHardness")
@PropertyType(value=ExpressionType.COMBINED)
public class ExprBlockHardness
extends SimpleExpression<Number> {
    private Expression<Block> block;

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.block = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "[the] block (break delay|durability|hardness) of [all] %block%";
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.block != null) {
            return new Number[]{Float.valueOf(ExprBlockHardness.getHardness((Block)this.block.getSingle(e)))};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Number strength = (Number)delta[0];
        if (this.block != null) {
            try {
                Float strengthNow = Float.valueOf(ExprBlockHardness.getHardness((Block)this.block.getSingle(e)));
                Method method = ReflectionUtil.getNMSClass("Block").getDeclaredMethod("c", Float.TYPE);
                method.setAccessible(true);
                Object nmsBlock = ReflectionUtil.getNMSBlock((Block)this.block.getSingle(e));
                if (mode == Changer.ChangeMode.SET) {
                    method.invoke(nmsBlock, Float.valueOf(strength.floatValue()));
                } else if (mode == Changer.ChangeMode.ADD) {
                    method.invoke(nmsBlock, Float.valueOf(strength.floatValue() + ((Number)strengthNow).floatValue()));
                } else if (mode == Changer.ChangeMode.REMOVE) {
                    method.invoke(nmsBlock, Float.valueOf(strength.floatValue() - ((Number)strengthNow).floatValue()));
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                e1.printStackTrace();
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    private static float getHardness(Block block) {
        try {
            Object nmsBlock = ReflectionUtil.getNMSBlock(block);
            Field field = ReflectionUtil.getNMSClass("Block").getDeclaredField("strength");
            field.setAccessible(true);
            return field.getFloat(nmsBlock);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            e1.printStackTrace();
            return 0.0f;
        }
    }
}

